﻿using System;
using System.Collections.Generic;
using VA.PPMS.Context;

namespace PpmsDataWebService.ModelsEnumTypes
{
    public enum VAProviderRelationship
    {
        CCN = 1,
        Choice = 2,
        IndividualAuthorization = 3,
        LocalContract = 4,
        PC3 = 5,
        ProviderAgreement = 6,
        VAProvider = 7,
        PostAcuteMedicalOfClearLake = 8

    }

    public struct VAProviderRelationshipId
    {
        public VAProviderRelationshipId(int number, string name, int relationshipTypeId, string relationshipTypeName ) : this()
        {
            Number = number;
            Name = name;
            RelationshipTypeId = relationshipTypeId;
            RelationshipTypeName = relationshipTypeName;

        }

        public int Number { get; }
        
        public string Name { get; }

        public int RelationshipTypeId { get; }

        public string RelationshipTypeName { get; }
    }

    public class VAProviderRelationshipIds
    {
        private static List<VAProviderRelationshipId> _vaProviderRelationshipIds;
        static VAProviderRelationshipIds()
        {
            _vaProviderRelationshipIds = new List<VAProviderRelationshipId>();
            _vaProviderRelationshipIds.Add(new VAProviderRelationshipId(1, "CCN", 767940005, "Network"));
            _vaProviderRelationshipIds.Add(new VAProviderRelationshipId(2, "Choice", 767940008, "Choice"));
            _vaProviderRelationshipIds.Add(new VAProviderRelationshipId(3, "IndividualAuthorization", 767940000, "VA"));
            _vaProviderRelationshipIds.Add(new VAProviderRelationshipId(4, "LocalContract", 767940000, "VA"));
            _vaProviderRelationshipIds.Add(new VAProviderRelationshipId(5, "PC3", 767940009, "PC3"));
            _vaProviderRelationshipIds.Add(new VAProviderRelationshipId(6, "ProviderAgreement", 767940000, "VA"));
            _vaProviderRelationshipIds.Add(new VAProviderRelationshipId(7, "VAProvider", 767940000, "VA"));
            _vaProviderRelationshipIds.Add(new VAProviderRelationshipId(8, "PostAcuteMedicalOfClearLake", 767940010, "PostAcuteMedicalOfClearLake"));
        }

        public static VAProviderRelationshipId GetVAProviderRelationship(int number)
        {
            return _vaProviderRelationshipIds.Find(n => n.Number == number);
        }

        public static VAProviderRelationshipId GetVAProviderRelationship(string name)
        {
            return _vaProviderRelationshipIds.Find(n => n.Name == name);
        }
    }
}